
/*
* ------------------------------------------------------------------------------
* Users js file 
* Includes scripts for user management
* Author Dinesh Kumar Muthukrishnan 
* -------------------------------------------------------------------------------
*/

/*
* Clear message 
*/


$(document).ready(function () {
	var navListItems = $('div.setup-panel div a'),
		allWells = $('.setup-content'),
		allNextBtn = $('.nextBtn');
		allWells.hide();

	navListItems.click(function (e) {
		e.preventDefault();
		var $target = $($(this).attr('href')),
			$item = $(this);
		if (!$item.hasClass('disabled')) {
			navListItems.removeClass('btn-primary').addClass('btn-default');
			$item.addClass('btn-primary');
			allWells.hide();
			$target.show();
			$target.find('input:eq(0)').focus();
		}
	});
	$('div.setup-panel div a.btn-primary').trigger('click');
});


$(document).ready(function() {
	$('.message').html('');	

	$('#Users').DataTable({
        'processing': true,
        'serverSide': true,
        'serverMethod': 'post',
        'ajax': {
            'url':'grid-users.php'
        },
        "columnDefs": [
        	{"className": "dt-center", "targets": [-1,-2] }
      	],
        'columns': [
        	{ data: 'user_id' },            
            { data: 'name' },            
            { data: 'type' },            
            { data: 'phone' },
            { data: 'token' },
            { data: 'active' },                        
            { data: 'edit' },                        
            { data: 'delete' },                        
        ]
    });     
});


/*
* Primary Category click event handler
*/
$(document).on('click','#CategoryBtn',function() {
	var role_name        = $('#role_name').val();	
	var active           = $('#active').val();	
	var formData         = new FormData( $('#roleForm')[0] );	
	var message          = '';
	var flag             = 1 ;

	if( role_name == "" ){
		message = "Please enter RoleName";
		flag = 0;
		$('#role_name').focus();
		$('.message').addClass('error').html(message);
	}	
	
	if ( active == "-1" ){
		message = "Please enter password";
		flag = 0;
		$('#active').focus();
		$('.message').addClass('error').html(message);
	}

	if ( flag == 1 ){
		$.ajax({
			url  : serverUrl+'PostRoles.php',
			data : formData,
			method : 'POST',
			processData: false,
    		contentType: false,
			success: function( response ) {
				console.log(response);
				var objData = JSON.parse( response );
				if( objData.code == 200 ){					
					$('.message').addClass('success').html(message);
					setTimeout(function(){
						window.location.href = objData.url+'.php'; }, 1000 );		       		
			    }
			   	if( objData.code == 404 || objData.code == 405 ){	       	
		   			message = objData.data;
		   			$('.message').addClass('error').html(message);
		   		}	
		    },
		    error: function () {
		        if( response.code == 401 ){
		       		window.location.replace('/');		       	
		        }
		        $('.message').addClass('error').html(message);
		    } 
		});
	}
});

$(document).on('click','#submitValue',function() {
var fdata = $("#userData").serialize();

		$.ajax({
			url:serverUrl + 'PostUsers.php',
			method:'POST',
			data:fdata,
			success: function( response ) {
				alert(response);
				window.location.href = 'users.php';
		    },
		    error: function () {
		    } 
		});
});

$(document).on('click','#updateValue',function() {
 var editData = $("#userData").serialize();
	$.ajax({
		url:serverUrl + 'editUser.php',
		method:'POST',
		data:editData,
		success:function( response ) {
				console.log(response);
		  	window.location.href = 'users.php';

			
 	    },
		error:function () {
		  	window.location.href = 'users.php';
		  					console.log("error");

		} 
	});
});

$(document).on('click','.validationClick1',function() {
	var userName    = $('#name').val();
	var password    = $('#password').val();
	var email   	= $('#email').val();
	var mobile    	= $('#mobile').val();
	var altMobile   = $('#altMobile').val();
	var city    	= $('#city').val();
	var password    = $('#password').val();
	var password    = $('#password').val();
	var flag        = 1;
	if( altMobile == "" ){
		message = "Please enter Alternative Mobile Number";
		flag = 0;
		$('#altMobile').focus();
		$('.message').addClass('error').html(message);
	}	
	if( mobile == "" ){
		message = "Please enter Mobile";
		flag = 0;
		$('#mobile').focus();
		$('.message').addClass('error').html(message);
	}
	if( email == "" ){
		message = "Please enter Email";
		flag = 0;
		$('#email').focus();
		$('.message').addClass('error').html(message);
	}	
	if( password == "" ){
		message = "Please enter Password";
		flag = 0;
		$('#password').focus();
		$('.message').addClass('error').html(message);
	}	
	if( userName == "" ){
		message = "Please enter User Name";
		flag = 0;
		$('#name').focus();
		$('.message').addClass('error').html(message);
	}

	if( flag == 1 )	{
		loadNextSection();
	}
});


$(document).on('click','.validationClick2',function() {
	var city    	= $('#city').val();
	var state    	= $('#state').val();
	var country	    = $('#country').val();
	var pincode	    = $('#pincode').val();
	var address	    = $('#address').val();
	var flag        = 1;

	if( address == "" ){
		message = "Please enter Address";
		flag = 0;
		$('#address').focus();
		$('.message').addClass('error').html(message);
	}
	if( pincode == "" ){
		message = "Please enter pincode";
		flag = 0;
		$('#pincode').focus();
		$('.message').addClass('error').html(message);
	}
	if( country == "" ){
		message = "Please enter Country";
		flag = 0;
		$('#country').focus();
		$('.message').addClass('error').html(message);
	}	
	if( state == "" ){
		message = "Please enter State";
		flag = 0;
		$('#state').focus();
		$('.message').addClass('error').html(message);
	}	
	if( city == "" ){
		message = "Please enter City";
		flag = 0;
		$('#city').focus();
		$('.message').addClass('error').html(message);
	}
	if( flag == 1 )	{
		loadNextSection();
	}	
});
/*
* click on next button in wizard form
*/
function loadNextSection() {
	var navListItems = $('div.setup-panel div a'),
		allWells = $('.setup-content'),
		allNextBtn = $('.nextBtn');
		allWells.hide();
	var curStep = allNextBtn.closest(".setup-content"),
		curStepBtn = curStep.attr("id"),
		nextStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().next().children("a"),
		curInputs = curStep.find("input[type='text'],input[type='password'],input[type='select'],input[type='url']"),
		isValid = true;
		console.log( curStepBtn );
	if (isValid) {
		nextStepWizard.removeAttr('disabled').trigger('click');
	}
}
